// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_1_0_autogen.cpp:
//   Defines the GLES 1.0 entry points.

#include "libGLESv2/entry_points_gles_1_0_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_1_0_autogen.h"
#include "libANGLE/context_private_call.inl.h"
#include "libANGLE/context_private_call_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES1.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {
void GL_APIENTRY GL_AlphaFunc(GLenum func, GLfloat ref)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAlphaFunc, "context = %d, func = %s, ref = %f", CID(context),
          GLenumToString(GLESEnum::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked = PackParam<AlphaTestFunc>(func);
        bool isCallValid         = (context->skipValidation() ||
                            ValidateAlphaFunc(context->getPrivateState(),
                                                      context->getMutableErrorSetForValidation(),
                                                      angle::EntryPoint::GLAlphaFunc, funcPacked, ref));
        if (isCallValid)
        {
            ContextPrivateAlphaFunc(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), funcPacked, ref);
        }
        ANGLE_CAPTURE_GL(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_AlphaFuncx(GLenum func, GLfixed ref)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAlphaFuncx, "context = %d, func = %s, ref = 0x%X", CID(context),
          GLenumToString(GLESEnum::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked = PackParam<AlphaTestFunc>(func);
        bool isCallValid         = (context->skipValidation() ||
                            ValidateAlphaFuncx(context->getPrivateState(),
                                                       context->getMutableErrorSetForValidation(),
                                                       angle::EntryPoint::GLAlphaFuncx, funcPacked, ref));
        if (isCallValid)
        {
            ContextPrivateAlphaFuncx(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), funcPacked, ref);
        }
        ANGLE_CAPTURE_GL(AlphaFuncx, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearColorx,
          "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X", CID(context), red,
          green, blue, alpha);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearColorx(context->getPrivateState(),
                                 context->getMutableErrorSetForValidation(),
                                 angle::EntryPoint::GLClearColorx, red, green, blue, alpha));
        if (isCallValid)
        {
            ContextPrivateClearColorx(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), red, green, blue,
                                      alpha);
        }
        ANGLE_CAPTURE_GL(ClearColorx, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearDepthx(GLfixed depth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearDepthx, "context = %d, depth = 0x%X", CID(context), depth);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateClearDepthx(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLClearDepthx, depth));
        if (isCallValid)
        {
            ContextPrivateClearDepthx(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), depth);
        }
        ANGLE_CAPTURE_GL(ClearDepthx, isCallValid, context, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClientActiveTexture(GLenum texture)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClientActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLESEnum::TextureUnit, texture));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateClientActiveTexture(
                                context, angle::EntryPoint::GLClientActiveTexture, texture));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE_GL(ClientActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClipPlanef(GLenum p, const GLfloat *eqn)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipPlanef, "context = %d, p = %s, eqn = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::ClipPlaneName, p), (uintptr_t)eqn);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateClipPlanef(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLClipPlanef, p, eqn));
        if (isCallValid)
        {
            ContextPrivateClipPlanef(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), p, eqn);
        }
        ANGLE_CAPTURE_GL(ClipPlanef, isCallValid, context, p, eqn);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClipPlanex(GLenum plane, const GLfixed *equation)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateClipPlanex(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLClipPlanex, plane, equation));
        if (isCallValid)
        {
            ContextPrivateClipPlanex(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), plane, equation);
        }
        ANGLE_CAPTURE_GL(ClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4f, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4f(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLColor4f, red, green, blue, alpha));
        if (isCallValid)
        {
            ContextPrivateColor4f(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4f, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4ub, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4ub(context->getPrivateState(),
                              context->getMutableErrorSetForValidation(),
                              angle::EntryPoint::GLColor4ub, red, green, blue, alpha));
        if (isCallValid)
        {
            ContextPrivateColor4ub(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4x, "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateColor4x(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLColor4x, red, green, blue, alpha));
        if (isCallValid)
        {
            ContextPrivateColor4x(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4x, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateColorPointer(context, angle::EntryPoint::GLColorPointer, size,
                                                 typePacked, stride, pointer));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DepthRangex(GLfixed n, GLfixed f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthRangex, "context = %d, n = 0x%X, f = 0x%X", CID(context), n, f);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateDepthRangex(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLDepthRangex, n, f));
        if (isCallValid)
        {
            ContextPrivateDepthRangex(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), n, f);
        }
        ANGLE_CAPTURE_GL(DepthRangex, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableClientState(GLenum array)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLESEnum::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateDisableClientState(
                                context, angle::EntryPoint::GLDisableClientState, arrayPacked));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(DisableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EnableClientState(GLenum array)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLESEnum::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateEnableClientState(
                                context, angle::EntryPoint::GLEnableClientState, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(EnableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogf(GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::FogParameter, pname), param);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFogf(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                          angle::EntryPoint::GLFogf, pname, param));
        if (isCallValid)
        {
            ContextPrivateFogf(context->getMutablePrivateState(),
                               context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(Fogf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogfv(GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFogfv(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                           angle::EntryPoint::GLFogfv, pname, params));
        if (isCallValid)
        {
            ContextPrivateFogfv(context->getMutablePrivateState(),
                                context->getMutablePrivateStateCache(), pname, params);
        }
        ANGLE_CAPTURE_GL(Fogfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogx(GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::FogPName, pname), param);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFogx(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                          angle::EntryPoint::GLFogx, pname, param));
        if (isCallValid)
        {
            ContextPrivateFogx(context->getMutablePrivateState(),
                               context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(Fogx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogxv(GLenum pname, const GLfixed *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::FogPName, pname), (uintptr_t)param);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFogxv(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                           angle::EntryPoint::GLFogxv, pname, param));
        if (isCallValid)
        {
            ContextPrivateFogxv(context->getMutablePrivateState(),
                                context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(Fogxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Frustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrustumf, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateFrustumf(context->getPrivateState(),
                                             context->getMutableErrorSetForValidation(),
                                             angle::EntryPoint::GLFrustumf, l, r, b, t, n, f));
        if (isCallValid)
        {
            ContextPrivateFrustumf(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Frustumf, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Frustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrustumx,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateFrustumx(context->getPrivateState(),
                                             context->getMutableErrorSetForValidation(),
                                             angle::EntryPoint::GLFrustumx, l, r, b, t, n, f));
        if (isCallValid)
        {
            ContextPrivateFrustumx(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Frustumx, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetClipPlanef(GLenum plane, GLfloat *equation)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetClipPlanef, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetClipPlanef(context->getPrivateState(),
                                   context->getMutableErrorSetForValidation(),
                                   angle::EntryPoint::GLGetClipPlanef, plane, equation));
        if (isCallValid)
        {
            ContextPrivateGetClipPlanef(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), plane, equation);
        }
        ANGLE_CAPTURE_GL(GetClipPlanef, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetClipPlanex(GLenum plane, GLfixed *equation)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetClipPlanex(context->getPrivateState(),
                                   context->getMutableErrorSetForValidation(),
                                   angle::EntryPoint::GLGetClipPlanex, plane, equation));
        if (isCallValid)
        {
            ContextPrivateGetClipPlanex(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), plane, equation);
        }
        ANGLE_CAPTURE_GL(GetClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFixedv(GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFixedv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetFixedv(context, angle::EntryPoint::GLGetFixedv, pname, params));
        if (isCallValid)
        {
            context->getFixedv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetFixedv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetLightfv(context->getPrivateState(),
                                context->getMutableErrorSetForValidation(),
                                angle::EntryPoint::GLGetLightfv, light, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetLightfv(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), light, pnamePacked,
                                     params);
        }
        ANGLE_CAPTURE_GL(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetLightxv(context->getPrivateState(),
                                context->getMutableErrorSetForValidation(),
                                angle::EntryPoint::GLGetLightxv, light, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetLightxv(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), light, pnamePacked,
                                     params);
        }
        ANGLE_CAPTURE_GL(GetLightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialfv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMaterialfv(context->getPrivateState(),
                                   context->getMutableErrorSetForValidation(),
                                   angle::EntryPoint::GLGetMaterialfv, face, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetMaterialfv(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), face, pnamePacked,
                                        params);
        }
        ANGLE_CAPTURE_GL(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialxv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetMaterialxv(context->getPrivateState(),
                                   context->getMutableErrorSetForValidation(),
                                   angle::EntryPoint::GLGetMaterialxv, face, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetMaterialxv(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), face, pnamePacked,
                                        params);
        }
        ANGLE_CAPTURE_GL(GetMaterialxv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnvfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexEnvfv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLGetTexEnvfv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetTexEnvfv(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), targetPacked,
                                      pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnviv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexEnviv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLGetTexEnviv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetTexEnviv(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), targetPacked,
                                      pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnvxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexEnvxv(
                 context->getPrivateState(), context->getMutableErrorSetForValidation(),
                 angle::EntryPoint::GLGetTexEnvxv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateGetTexEnvxv(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), targetPacked,
                                      pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexParameterxv(context, angle::EntryPoint::GLGetTexParameterxv,
                                       targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelf(GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::LightModelParameter, pname), param);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLightModelf(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLLightModelf, pname, param));
        if (isCallValid)
        {
            ContextPrivateLightModelf(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelfv(GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLightModelfv(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLLightModelfv, pname, params));
        if (isCallValid)
        {
            ContextPrivateLightModelfv(context->getMutablePrivateState(),
                                       context->getMutablePrivateStateCache(), pname, params);
        }
        ANGLE_CAPTURE_GL(LightModelfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelx(GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::LightModelParameter, pname), param);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLightModelx(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLLightModelx, pname, param));
        if (isCallValid)
        {
            ContextPrivateLightModelx(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelxv(GLenum pname, const GLfixed *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightModelParameter, pname), (uintptr_t)param);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLightModelxv(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLLightModelxv, pname, param));
        if (isCallValid)
        {
            ContextPrivateLightModelxv(context->getMutablePrivateState(),
                                       context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightf(GLenum light, GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightf, "context = %d, light = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightf(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLLightf, light, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateLightf(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), light, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Lightf, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightfv(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLLightfv, light, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateLightfv(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), light, pnamePacked,
                                  params);
        }
        ANGLE_CAPTURE_GL(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightx(GLenum light, GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightx, "context = %d, light = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightx(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLLightx, light, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateLightx(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), light, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Lightx, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLightxv(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLLightxv, light, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateLightxv(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), light, pnamePacked,
                                  params);
        }
        ANGLE_CAPTURE_GL(Lightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LineWidthx(GLfixed width)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLineWidthx, "context = %d, width = 0x%X", CID(context), width);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLineWidthx(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLLineWidthx, width));
        if (isCallValid)
        {
            ContextPrivateLineWidthx(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), width);
        }
        ANGLE_CAPTURE_GL(LineWidthx, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadIdentity()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadIdentity, "context = %d", CID(context));

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLoadIdentity(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLLoadIdentity));
        if (isCallValid)
        {
            ContextPrivateLoadIdentity(context->getMutablePrivateState(),
                                       context->getMutablePrivateStateCache());
        }
        ANGLE_CAPTURE_GL(LoadIdentity, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadMatrixf(const GLfloat *m)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLoadMatrixf(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLLoadMatrixf, m));
        if (isCallValid)
        {
            ContextPrivateLoadMatrixf(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadMatrixx(const GLfixed *m)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateLoadMatrixx(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLLoadMatrixx, m));
        if (isCallValid)
        {
            ContextPrivateLoadMatrixx(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LogicOp(GLenum opcode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLogicOp, "context = %d, opcode = %s", CID(context),
          GLenumToString(GLESEnum::LogicOp, opcode));

    if (context)
    {
        LogicalOperation opcodePacked = PackParam<LogicalOperation>(opcode);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateLogicOp(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLLogicOp, opcodePacked));
        if (isCallValid)
        {
            ContextPrivateLogicOp(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), opcodePacked);
        }
        ANGLE_CAPTURE_GL(LogicOp, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialf(GLenum face, GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialf, "context = %d, face = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialf(context->getPrivateState(),
                               context->getMutableErrorSetForValidation(),
                               angle::EntryPoint::GLMaterialf, face, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateMaterialf(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), face, pnamePacked,
                                    param);
        }
        ANGLE_CAPTURE_GL(Materialf, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialfv, "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialfv(context->getPrivateState(),
                                context->getMutableErrorSetForValidation(),
                                angle::EntryPoint::GLMaterialfv, face, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateMaterialfv(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), face, pnamePacked,
                                     params);
        }
        ANGLE_CAPTURE_GL(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialx(GLenum face, GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialx, "context = %d, face = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialx(context->getPrivateState(),
                               context->getMutableErrorSetForValidation(),
                               angle::EntryPoint::GLMaterialx, face, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateMaterialx(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), face, pnamePacked,
                                    param);
        }
        ANGLE_CAPTURE_GL(Materialx, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialxv, "context = %d, face = %s, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMaterialxv(context->getPrivateState(),
                                context->getMutableErrorSetForValidation(),
                                angle::EntryPoint::GLMaterialxv, face, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateMaterialxv(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), face, pnamePacked,
                                     param);
        }
        ANGLE_CAPTURE_GL(Materialxv, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MatrixMode(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMatrixMode, "context = %d, mode = %s", CID(context),
          GLenumToString(GLESEnum::MatrixMode, mode));

    if (context)
    {
        MatrixType modePacked = PackParam<MatrixType>(mode);
        bool isCallValid      = (context->skipValidation() ||
                            ValidateMatrixMode(context->getPrivateState(),
                                                    context->getMutableErrorSetForValidation(),
                                                    angle::EntryPoint::GLMatrixMode, modePacked));
        if (isCallValid)
        {
            ContextPrivateMatrixMode(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), modePacked);
        }
        ANGLE_CAPTURE_GL(MatrixMode, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultMatrixf(const GLfloat *m)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateMultMatrixf(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultMatrixf, m));
        if (isCallValid)
        {
            ContextPrivateMultMatrixf(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), m);
        }
        ANGLE_CAPTURE_GL(MultMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultMatrixx(const GLfixed *m)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateMultMatrixx(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLMultMatrixx, m));
        if (isCallValid)
        {
            ContextPrivateMultMatrixx(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), m);
        }
        ANGLE_CAPTURE_GL(MultMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4f, "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f",
          CID(context), GLenumToString(GLESEnum::TextureUnit, target), s, t, r, q);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4f(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLMultiTexCoord4f, target, s, t, r, q));
        if (isCallValid)
        {
            ContextPrivateMultiTexCoord4f(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), target, s, t, r,
                                          q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4x,
          "context = %d, texture = %s, s = 0x%X, t = 0x%X, r = 0x%X, q = 0x%X", CID(context),
          GLenumToString(GLESEnum::TextureUnit, texture), s, t, r, q);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateMultiTexCoord4x(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLMultiTexCoord4x, texture, s, t, r, q));
        if (isCallValid)
        {
            ContextPrivateMultiTexCoord4x(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), texture, s, t, r,
                                          q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4x, isCallValid, context, texture, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3f, "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateNormal3f(context->getPrivateState(),
                                             context->getMutableErrorSetForValidation(),
                                             angle::EntryPoint::GLNormal3f, nx, ny, nz));
        if (isCallValid)
        {
            ContextPrivateNormal3f(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3f, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3x, "context = %d, nx = 0x%X, ny = 0x%X, nz = 0x%X", CID(context), nx,
          ny, nz);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateNormal3x(context->getPrivateState(),
                                             context->getMutableErrorSetForValidation(),
                                             angle::EntryPoint::GLNormal3x, nx, ny, nz));
        if (isCallValid)
        {
            ContextPrivateNormal3x(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3x, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormalPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::NormalPointerType, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateNormalPointer(context, angle::EntryPoint::GLNormalPointer,
                                                  typePacked, stride, pointer));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Orthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLOrthof, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateOrthof(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLOrthof, l, r, b, t, n, f));
        if (isCallValid)
        {
            ContextPrivateOrthof(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Orthof, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Orthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLOrthox,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateOrthox(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLOrthox, l, r, b, t, n, f));
        if (isCallValid)
        {
            ContextPrivateOrthox(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Orthox, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterf(GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::AllEnums, pname), param);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePointParameterf(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLPointParameterf, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivatePointParameterf(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), pnamePacked,
                                          param);
        }
        ANGLE_CAPTURE_GL(PointParameterf, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterfv(GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePointParameterfv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLPointParameterfv, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivatePointParameterfv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), pnamePacked,
                                           params);
        }
        ANGLE_CAPTURE_GL(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterx(GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::AllEnums, pname), param);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePointParameterx(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLPointParameterx, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivatePointParameterx(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), pnamePacked,
                                          param);
        }
        ANGLE_CAPTURE_GL(PointParameterx, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterxv(GLenum pname, const GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterxv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePointParameterxv(context->getPrivateState(),
                                      context->getMutableErrorSetForValidation(),
                                      angle::EntryPoint::GLPointParameterxv, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivatePointParameterxv(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), pnamePacked,
                                           params);
        }
        ANGLE_CAPTURE_GL(PointParameterxv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointSize(GLfloat size)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSize, "context = %d, size = %f", CID(context), size);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidatePointSize(context->getPrivateState(),
                                              context->getMutableErrorSetForValidation(),
                                              angle::EntryPoint::GLPointSize, size));
        if (isCallValid)
        {
            ContextPrivatePointSize(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), size);
        }
        ANGLE_CAPTURE_GL(PointSize, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointSizex(GLfixed size)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSizex, "context = %d, size = 0x%X", CID(context), size);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidatePointSizex(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLPointSizex, size));
        if (isCallValid)
        {
            ContextPrivatePointSizex(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), size);
        }
        ANGLE_CAPTURE_GL(PointSizex, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PolygonOffsetx(GLfixed factor, GLfixed units)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonOffsetx, "context = %d, factor = 0x%X, units = 0x%X", CID(context),
          factor, units);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePolygonOffsetx(context->getPrivateState(),
                                    context->getMutableErrorSetForValidation(),
                                    angle::EntryPoint::GLPolygonOffsetx, factor, units));
        if (isCallValid)
        {
            ContextPrivatePolygonOffsetx(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), factor, units);
        }
        ANGLE_CAPTURE_GL(PolygonOffsetx, isCallValid, context, factor, units);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PopMatrix()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopMatrix, "context = %d", CID(context));

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidatePopMatrix(context->getPrivateState(),
                                              context->getMutableErrorSetForValidation(),
                                              angle::EntryPoint::GLPopMatrix));
        if (isCallValid)
        {
            ContextPrivatePopMatrix(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache());
        }
        ANGLE_CAPTURE_GL(PopMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PushMatrix()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushMatrix, "context = %d", CID(context));

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidatePushMatrix(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLPushMatrix));
        if (isCallValid)
        {
            ContextPrivatePushMatrix(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache());
        }
        ANGLE_CAPTURE_GL(PushMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotatef, "context = %d, angle = %f, x = %f, y = %f, z = %f", CID(context),
          angle, x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRotatef(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLRotatef, angle, x, y, z));
        if (isCallValid)
        {
            ContextPrivateRotatef(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotatef, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotatex, "context = %d, angle = 0x%X, x = 0x%X, y = 0x%X, z = 0x%X",
          CID(context), angle, x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateRotatex(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLRotatex, angle, x, y, z));
        if (isCallValid)
        {
            ContextPrivateRotatex(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotatex, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SampleCoveragex(GLclampx value, GLboolean invert)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSampleCoveragex, "context = %d, value = 0x%X, invert = %s", CID(context),
          value, GLbooleanToString(invert));

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateSampleCoveragex(context->getPrivateState(),
                                     context->getMutableErrorSetForValidation(),
                                     angle::EntryPoint::GLSampleCoveragex, value, invert));
        if (isCallValid)
        {
            ContextPrivateSampleCoveragex(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), value, invert);
        }
        ANGLE_CAPTURE_GL(SampleCoveragex, isCallValid, context, value, invert);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScalef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateScalef(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLScalef, x, y, z));
        if (isCallValid)
        {
            ContextPrivateScalef(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), x, y, z);
        }
        ANGLE_CAPTURE_GL(Scalef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScalex, "context = %d, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), x, y, z);

    if (context)
    {
        bool isCallValid =
            (context->skipValidation() ||
             ValidateScalex(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                            angle::EntryPoint::GLScalex, x, y, z));
        if (isCallValid)
        {
            ContextPrivateScalex(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), x, y, z);
        }
        ANGLE_CAPTURE_GL(Scalex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ShadeModel(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadeModel, "context = %d, mode = %s", CID(context),
          GLenumToString(GLESEnum::ShadingModel, mode));

    if (context)
    {
        ShadingModel modePacked = PackParam<ShadingModel>(mode);
        bool isCallValid        = (context->skipValidation() ||
                            ValidateShadeModel(context->getPrivateState(),
                                                      context->getMutableErrorSetForValidation(),
                                                      angle::EntryPoint::GLShadeModel, modePacked));
        if (isCallValid)
        {
            ContextPrivateShadeModel(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), modePacked);
        }
        ANGLE_CAPTURE_GL(ShadeModel, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::TexCoordPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateTexCoordPointer(context, angle::EntryPoint::GLTexCoordPointer,
                                                    size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(TexCoordPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvf, "context = %d, target = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnvf(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLTexEnvf, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateTexEnvf(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), targetPacked, pnamePacked,
                                  param);
        }
        ANGLE_CAPTURE_GL(TexEnvf, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvfv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnvfv(context->getPrivateState(),
                              context->getMutableErrorSetForValidation(),
                              angle::EntryPoint::GLTexEnvfv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateTexEnvfv(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), targetPacked,
                                   pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvi(GLenum target, GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvi, "context = %d, target = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnvi(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLTexEnvi, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateTexEnvi(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), targetPacked, pnamePacked,
                                  param);
        }
        ANGLE_CAPTURE_GL(TexEnvi, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnviv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnviv(context->getPrivateState(),
                              context->getMutableErrorSetForValidation(),
                              angle::EntryPoint::GLTexEnviv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateTexEnviv(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), targetPacked,
                                   pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvx, "context = %d, target = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnvx(context->getPrivateState(), context->getMutableErrorSetForValidation(),
                             angle::EntryPoint::GLTexEnvx, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            ContextPrivateTexEnvx(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), targetPacked, pnamePacked,
                                  param);
        }
        ANGLE_CAPTURE_GL(TexEnvx, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvxv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexEnvxv(context->getPrivateState(),
                              context->getMutableErrorSetForValidation(),
                              angle::EntryPoint::GLTexEnvxv, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            ContextPrivateTexEnvxv(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), targetPacked,
                                   pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterx, "context = %d, target = %s, pname = %s, param = 0x%X",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), param);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateTexParameterx(context, angle::EntryPoint::GLTexParameterx,
                                                  targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterx(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameterx, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateTexParameterxv(context, angle::EntryPoint::GLTexParameterxv,
                                                   targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslatef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateTranslatef(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLTranslatef, x, y, z));
        if (isCallValid)
        {
            ContextPrivateTranslatef(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), x, y, z);
        }
        ANGLE_CAPTURE_GL(Translatef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslatex, "context = %d, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), x, y,
          z);

    if (context)
    {
        bool isCallValid = (context->skipValidation() ||
                            ValidateTranslatex(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLTranslatex, x, y, z));
        if (isCallValid)
        {
            ContextPrivateTranslatex(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), x, y, z);
        }
        ANGLE_CAPTURE_GL(Translatex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::VertexPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateVertexPointer(context, angle::EntryPoint::GLVertexPointer, size,
                                                  typePacked, stride, pointer));
        if (isCallValid)
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(VertexPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
