; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Verify that the special case of memchr calls with the size of 1 are
; folded as expected.

declare ptr @memchr(ptr, i32, i64)

@ax = external global [0 x i8]
@a12345 = constant [5 x i8] c"\01\02\03\04\05"


; Fold memchr(a12345, 1, 1) to a12345.

define ptr @fold_memchr_a12345_1_1() {
; CHECK-LABEL: @fold_memchr_a12345_1_1(
; CHECK-NEXT:    ret ptr @a12345
;

  %res = call ptr @memchr(ptr @a12345, i32 1, i64 1)
  ret ptr %res
}


; Fold memchr(a12345, 2, 1) to null.

define ptr @fold_memchr_a12345_2_1() {
; CHECK-LABEL: @fold_memchr_a12345_2_1(
; CHECK-NEXT:    ret ptr null
;

  %res = call ptr @memchr(ptr @a12345, i32 2, i64 1)
  ret ptr %res
}


; Fold memchr(ax, 257, 1) to (unsigned char)*ax == 1 ? ax : null
; to verify the constant 257 is converted to unsigned char (yielding 1).

define ptr @fold_memchr_ax_257_1(i32 %chr, i64 %n) {
; CHECK-LABEL: @fold_memchr_ax_257_1(
; CHECK-NEXT:    [[MEMCHR_CHAR0:%.*]] = load i8, ptr @ax, align 1
; CHECK-NEXT:    [[MEMCHR_CHAR0CMP:%.*]] = icmp eq i8 [[MEMCHR_CHAR0]], 1
; CHECK-NEXT:    [[MEMCHR_SEL:%.*]] = select i1 [[MEMCHR_CHAR0CMP]], ptr @ax, ptr null
; CHECK-NEXT:    ret ptr [[MEMCHR_SEL]]
;

  %res = call ptr @memchr(ptr @ax, i32 257, i64 1)
  ret ptr %res
}


; Fold memchr(ax, c, 1) to (unsigned char)*ax == (unsigned char)c ? ax : null.

define ptr @fold_memchr_ax_c_1(i32 %chr, i64 %n) {
; CHECK-LABEL: @fold_memchr_ax_c_1(
; CHECK-NEXT:    [[MEMCHR_CHAR0:%.*]] = load i8, ptr @ax, align 1
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[CHR:%.*]] to i8
; CHECK-NEXT:    [[MEMCHR_CHAR0CMP:%.*]] = icmp eq i8 [[MEMCHR_CHAR0]], [[TMP1]]
; CHECK-NEXT:    [[MEMCHR_SEL:%.*]] = select i1 [[MEMCHR_CHAR0CMP]], ptr @ax, ptr null
; CHECK-NEXT:    ret ptr [[MEMCHR_SEL]]
;

  %res = call ptr @memchr(ptr @ax, i32 %chr, i64 1)
  ret ptr %res
}
