from Products.PlugIns import PlugIn, PlugInGroup, defaultConstructors
from Globals import HTMLFile, default__class_init__
from OFS.PropertyManager import PropertyManager

class NullProvider:
    def _objectAdding(self,client): pass
    def _objectCreating(self,client): pass
    def _objectChanging(self,client): pass
    def _objectDeleting(self,client): pass
    def _getProviders(self): return self,


class Provider(PlugIn, NullProvider, PropertyManager):
    """Simple properties-based interface for attribute and sheet providers"""

    manage_options = (
        {'label':'Properties', 'action':'manage_propertiesForm'},
    )

    def manage_editProperties(self, REQUEST):
        """Edit object properties via the web."""
        r = PropertyManager.manage_editProperties(self,REQUEST)
        self._propertiesChanged()
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        return r

    def manage_changeProperties(self, REQUEST=None, **kw):
        """Change existing object properties."""
        r = apply(PropertyManager.manage_changeProperties,(self,REQUEST),kw)
        self._propertiesChanged()
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        return r

    def manage_addProperty(self, id, value, type, REQUEST=None):
        """Add a new property via the web. Sets a new property with
        the given id, type, and value."""
        r = PropertyManager.manage_addProperty(self,id,value,type,REQUEST)
        self._propertiesChanged()
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        return r

    def manage_delProperties(self, ids=None, REQUEST=None):
        """Delete one or more properties specified by 'ids'."""
        r = PropertyManager.manage_delProperties(self,ids,REQUEST)
        self._propertiesChanged()
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        return r

    def _propertiesChanged(self): pass

    def propertyLabel(self,id):
        return self.propertyLabels.get(id,id)

    propertyLabels={}

default__class_init__(Provider)


























class ProviderGroup(PlugInGroup):
    """
    PlugInGroup that manages the more complex registration needs 
    of Attribute/Sheet/etc. Providers
    """

    def _PlugInsChanged(self, container, plugins=()):

        """Update the registry of names"""

        r = container.__provider_registry__ = {}
        l = container.__allProviders__ = []
        
        for bp in plugins:
        
            for plugin in bp.__of__(container)._getProviders():
            
                l.append(plugin)    
                nametable = plugin.namesForRegistration(container)

                for namekind, names in nametable.items():
                    d = r.get(namekind,{})
                
                    for n in names:
                        if d.has_key(n):
                            d[n].append(plugin)
                        else:
                            d[n]=[plugin]
                        
                    r[namekind] = d


    manage_below = HTMLFile('www/showDiagnostics', globals())

    def manage_registry(self,name):
        return self.aq_parent._getRegistry(name)





    def manage_attrMap(self):
    
        g=self.manage_registry('getattr')
        s=self.manage_registry('setattr')
        d=self.manage_registry('delattr')
        
        m={}; m.update(g); m.update(s); m.update(d)

        for k in m.keys():
            v = m[k] = {'rd':[],'wr':[], 'del':[]}
            if g.has_key(k): v['rd']=g[k]
            if s.has_key(k): v['wr']=s[k]
            if d.has_key(k): v['del']=s[k]

        return m.items()
        
    __ac_permissions__ = (
        ('View management screens',
            ('manage_registry','manage_attrMap','manage_below')
        ),
    )

default__class_init__(ProviderGroup)


















class ProviderContainer:

    __provider_registry__ = {}
    __dataProviders__ = ()
    __allProviders__ = ()
    
    DataPlugins = ProviderGroup(
        'DataPlugins',
        ['Property Sheet Provider','Attribute Provider', 'Monitoring Agent',
          'Data Plug-in'],
        title = 'Data Plug-ins',
        attr  = '__dataProviders__'
    )

    __plugin_groups__ = (DataPlugins,)
    
    def _getRegistry(self,name):
        return self.__provider_registry__.get(name,{})
        

    def _uniqueProviders(self,kinds):
        d = {}; have = d.has_key
        l = []
        providers = self._getRegistry('provides')
        
        for kind in kinds:
            for pp in providers.get(kind,()):
                if have(id(pp)): continue
                l.append(pp.__of__(self)); d[id(pp)]=1
                
        return l

    def _getProvidersFor(self,client,kind,names):
        r = self._getRegistry(kind); l=[]
        for n in names:
            for p in r.get(n,()):
                l.append(p.__of__(self))
        return l



    def __setstate__(self,state):
    
        """Upgrade data structures from pre 0.4.0 versions"""
        
        d = self.__dict__; d.clear()
        
        if state.has_key('__provider_registry__'):
            if not state.has_key('__allProviders__') and \
                state.has_key('__dataProviders__'):
                    state['__allProviders__']=state['__dataProviders__']
            d.update(state)
            return

        p = {}
        l = state['__dataProviders__'] = state['__allProviders__'] = []
        r = state['__provider_registry__'] = {'provides':p}

        for new,old in (
                ('sheets',    '__sheetProviders__'),
                ('attributes','__attributeProviders__'),
                ('handlers','__indexAgents__'),
                ('handlers','__triggerAgents__'),
            ):
            if state.has_key(old):
                p[new] = state[old]; l.extend(state[old])
                del state[old]

        for new,old in (
                ('getattr', '__getattr_registry__'),
                ('setattr', '__setattr_registry__'),
                ('sheet_names', '__sheet_registry__'),
                ('sheet_xmlns', '__xmlns_registry__'),
            ):
            if state.has_key(old):
                r[new] = state[old]
                del state[old]





        for ap in 'getattr','setattr':
            if r.has_key(ap):
                z = r[ap]
                for k,v in z.items(): z[k] = [v]    # new registry expects provider list

        if r.has_key('setattr'): r['delattr'] = r['setattr'].copy()       
        d.update(state)        


































class LinkToParentProviders(Provider):

    """Provide attributes, etc. from an acquired provider"""

    meta_type='Link to parent Data Plug-ins'
    __plugin_kind__ = 'Data Plug-in'

    excludePIs=()
    
    def _getProviders(self):
        r=getattr(self.aq_inner.aq_parent.aq_parent,'__allProviders__',())
        return filter(lambda x,exclude=tuple(self.excludePIs): x.id not in exclude, r)

    def parentPIids(self):
        r=getattr(self.aq_inner.aq_parent.aq_parent,'__allProviders__',())
        return map(lambda x:x.id, r)
        
    _properties=(
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'excludePIs', 'type': 'multiple selection',
            'mode': 'w', 'select_variable':'parentPIids'},
    )

    propertyLabels={'excludePIs':'Use all parent plug-ins EXCEPT'}

    def _propertiesChanged(self):
        # get rid of old (pre 0.4.2) properties
        d = self.__dict__
        for k in 'Attributes','Sheet_Names','Sheet_Namespaces':
            if d.has_key(k): del d[k]

default__class_init__(LinkToParentProviders)









def initialize(context):

    context.registerPlugInClass(
        LinkToParentProviders,
        permission = 'Add Links to Parent Data Plug-ins',
        constructors = defaultConstructors(LinkToParentProviders,globals()),
        icon = 'www/acqattrprov.gif'
    )












































